package cn.com.servyou.dto.employee;

/**
 * @author ranjh
 * @since 20210729
 */
public enum DeclareEmployeeOption {
    YES("1", "人员申报"),
    NO("0", "不需要人员申报");

    private String code;

    private String desc;

    DeclareEmployeeOption(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DeclareEmployeeOption getByCode(String code) {
        for (DeclareEmployeeOption obj : DeclareEmployeeOption.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    /**
     * Getter for property 'code'.
     *
     * @return Value for property 'code'.
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter for property 'desc'.
     *
     * @return Value for property 'desc'.
     */
    public String getDesc() {
        return desc;
    }

}
