package cn.com.servyou.dto.employee;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author YuJiaqi
 * @version $Id: EmployeeDeclareFeedback.java v 0.1 2018/12/4 下午12:04 YuJiaqi Exp $$
 */
@Data
public class EmployeeDeclareFeedback implements Serializable {

    private static final long serialVersionUID = 280039841063279503L;

    @JsonProperty
    protected Long id;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    protected String name;

    /**
     * 证照类型名称
     */
    @JsonProperty("zzlx")
    protected String licenseType;

    /**
     * 证照号码
     */
    @JsonProperty("zzhm")
    protected String licenseNumber;

    /**
     * 其他证照号码
     */
    @JsonProperty("qtzzhm")
    private String otherLicenseNumber;

    /**
     * 其他证照类型name
     */
    @JsonProperty("qtzzlx")
    private String otherLicenseType;


    /**
     * 报送状态
     */
    @JsonProperty("sbzt")
    private String submissionState;

    /**
     * 人员验证状态
     */
    @JsonProperty("rzzt")
    private String authenticationState;

    /**
     * 银行卡账号状态
     *
     * @Description 0 待验核  1 验核通过  2 验核不通过  3 无（不存在）
     */
    @JsonProperty("yhkzhzt")
    private String bankAccountState;

    /**
     * 失败原因
     */
    @JsonProperty("sbyy")
    private String message;

    /**
     * 专项报送状态
     */
    @JsonProperty("clzt")
    private String deductionSubmissionState;

    /**
     * 专项报送结果原因
     */
    @JsonProperty("cljgms")
    private String deductionMessage;

    /**
     * 纳税人识别号
     */
    @JsonProperty("nsrsbh")
    private String empTaxpayerIdentifier;

    /**
     * 是否已建档
     *
     * @Description 返回是/否
     * 如果存在自然人档案号则返回是，反之则返回否
     */
    @JsonProperty("sfyjd")
    private String archiveState;
}
