package cn.com.servyou.dto.employee;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhouww
 * @since 20201029
 */
@Data
public class EmployeeQueryRequest {

    /**
     * 税号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 登记序号
     */
    @JsonProperty("djxhid")
    private String registrationNumber;

    /**
     * 企业名称
     */
    @JsonProperty("qymc")
    private String name;

    /**
     * 行政区划代码
     */
    @JsonProperty("areaid")
    private String area;

    /**
     * 部门编号
     */
    @JsonProperty("bmbh")
    private String deptNo;

    /**
     * 网上报税账号
     */
    @JsonProperty("wsxtyhm")
    private String taxAccount;

    /**
     * 申报密码
     */
    @JsonProperty("sbmm")
    private String declarePassword;

    /**
     * 加密申报密码
     */
    @JsonProperty("jmsbmm")
    private String encryptedDeclarePassword;

    /**
     * 实名账号
     */
    @JsonProperty("smzh")
    private String realNameAccount;

    /**
     * 实名密码
     */
    @JsonProperty("smmm")
    private String realNamePassword;

    /**
     * 加密实名密码
     */
    @JsonProperty("jmsmmm")
    private String encryptedRealNamePassword;

    /**
     * 密码类型
     */
    @JsonProperty("mmlx")
    private String passwordType = "0";

    /**
     * 所属月份
     */
    @JsonProperty("ssyf")
    private String month;

    /**
     * 页码
     */
    private Integer pageNo = Integer.valueOf(1);

    /**
     * 页尺寸
     */
    private Integer pageSize = Integer.valueOf(1000);

}
