/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2018 All Rights Reserved.
 */

package cn.com.servyou.dto.employee;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author wangzeh
 * @since 20200336
 */
@Data
public class VerifyResultVO {

    /**
     * 员工姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证照类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证照号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 开户银行
     */
    @JsonProperty("kkyh")
    private String depositBankName;

    /**
     * 银行账号
     */
    @JsonProperty("yhzh")
    private String bankAccount;

    /**
     * 开户银行省份
     */
    @JsonProperty("khyhsf")
    private String depositBankProvince;

    /**
     * 银行验证状态
     * 0-新建，1-处理中，2-完成，3-失败，4-超时作废'
     */
    @JsonProperty("yzzt")
    private String verifyState;

    /**
     * 校验结果
     */
    @JsonProperty("yzjg")
    private String verifyResult;
}
