package cn.com.servyou.dto.enums;

/**
 * 子女教育专项扣除中子女受教育阶段枚举
 *
 * @author Robin Wang  on 2018-12-05.
 */
public enum ChildEducationStageEnum {

    PRE_EDU("10", "学前教育阶段"),
    DUTY_EDU("20", "义务教育"),
    SENIOR_EDU("30", "高中阶段教育"),
    HIGHER_EDU("40", "高等教育");

    private String code;

    private String desc;

    ChildEducationStageEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ChildEducationStageEnum getByCode(String code) {
        for (ChildEducationStageEnum obj : ChildEducationStageEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static ChildEducationStageEnum getByDesc(String desc) {
        for (ChildEducationStageEnum obj : ChildEducationStageEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
