package cn.com.servyou.dto.enums;

/**
 * 继续教育类型枚举 学历/非学历继续教育
 *
 * @author zhouww
 * @since 20191024
 */
public enum ContinueEducationSituationEnum {

    EDUCATION_BACKGROUND_CONTINUE_EDU("10", "学历（学位）继续教育"),
    UN_EDUCATION_BACKGROUND_CONTINUE_EDU("20", "职业资格继续教育");

    private String code;

    private String desc;

    ContinueEducationSituationEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ContinueEducationSituationEnum getByCode(String code) {
        for (ContinueEducationSituationEnum obj : ContinueEducationSituationEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static ContinueEducationSituationEnum getByDesc(String desc) {
        for (ContinueEducationSituationEnum obj : ContinueEducationSituationEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
