package cn.com.servyou.dto.enums;

/**
 * 学历(学位)继续教育阶段代码表
 *
 * @author Robin Wang  on 2018-12-15.
 */
public enum ContinueEducationStageEnum {
    JUNIOR_EDU("20", "大学本科"),
    REGULAR_EDU("30", "大学专科"),
    MASTER_EDU("14", "硕士研究生"),
    DOCTOR_EDU("11", "博士研究生"),
    OTHER_EDU("91", "其他");

    private String code;

    private String desc;

    ContinueEducationStageEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ContinueEducationStageEnum getByCode(String code) {
        for (ContinueEducationStageEnum obj : ContinueEducationStageEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static ContinueEducationStageEnum getByDesc(String desc) {
        for (ContinueEducationStageEnum obj : ContinueEducationStageEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
