package cn.com.servyou.dto.enums;

/**
 * 非学历继续教育类型
 *
 * @author Robin Wang  on 2018-12-17.
 */
public enum ContinueEducationUndegreeTypeEnum {

    SKILL("21", "技能人员职业资格"),
    PROFESSION("22", "专业技术人员职业资格");

    private String code;

    private String desc;

    ContinueEducationUndegreeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ContinueEducationUndegreeTypeEnum getByCode(String code) {
        for (ContinueEducationUndegreeTypeEnum obj : ContinueEducationUndegreeTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static ContinueEducationUndegreeTypeEnum getByDesc(String desc) {
        for (ContinueEducationUndegreeTypeEnum obj : ContinueEducationUndegreeTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
