package cn.com.servyou.dto.enums;

/**
 * 校验码
 * 00 请求类异常
 * 01 企业注册类异常
 * 02 人员异常
 * 03 专项异常
 * 04 申报类异常
 * 05 缴款类异常
 * 10 算税异常
 * 11 人员并档查询
 * 99 通用
 *
 * @author zhouww
 * @since 20191024
 */
public enum DataCheckEnum {
    EMPLOYEE_REPEAT("980001", "人员列表重复"),
    EMPLOYEE_LICENSE_TYPE_EMPTY("980002", "证照类型为空"),
    EMPLOYEE_LICENSE_TYPE_ERROR("980003", "证照类型不正确"),
    EMPLOYEE_LICENSE_NUMBER_EMPTY("980004", "证照号码为空"),
    EMPLOYEE_LICENSE_NUMBER_ERROR("980005", "证照号码不正确"),
    EMPLOYEE_LICENSE_EMPTY("980006", "证照类型和证照号码为空"),
    ;

    private String code;

    private String desc;

    DataCheckEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取枚举
     *
     * @param  code code
     * @return
     */
    public static DataCheckEnum getByCode(String code) {
        for (DataCheckEnum obj : DataCheckEnum.values()) {
            if (obj.code.equalsIgnoreCase(code)) {
                return obj;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }
}
