package cn.com.servyou.dto.enums;

/**
 * 报表姓名
 *
 * @author zhouww
 * @since 20191024
 */
public enum DeclarationAppendixItemEnum {
    EXEMPT_INCOME("0", "免税附表"),
    INSURANCE("1", "商业健康险附表"),
    INCOME_DEDUCTION("2", "减免附表"),
    EXTENSION_ENDOWMENT_INSURANCE("3", "税延养老保险附表");

    private String code;

    private String desc;

    DeclarationAppendixItemEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DeclarationAppendixItemEnum getByCode(String code) {
        for (DeclarationAppendixItemEnum obj : DeclarationAppendixItemEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static DeclarationAppendixItemEnum getByDesc(String desc) {
        for (DeclarationAppendixItemEnum obj : DeclarationAppendixItemEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}