package cn.com.servyou.dto.enums;

import java.io.Serializable;

/**
 * 申报类型
 *
 * @author zhouww
 * @since 20191024
 */
public enum DeclarationTypeEnum implements Serializable {
    UNFILL("0", "未填写"),
    COMPLEX_INCOME("1", "综合所得预扣预缴"),
    CLASSIFICATION_INCOME("2", "分类所得代扣代缴"),
    NON_RESIDENTS_INCOME("3", "非居民所得代扣代缴"),
    RESTRICTED_STOCK_INCOME("4", "限售股所得代扣代缴");

    private String code;

    private String desc;

    DeclarationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DeclarationTypeEnum getByCode(String code) {
        for (DeclarationTypeEnum obj : DeclarationTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static DeclarationTypeEnum getByDesc(String desc) {
        for (DeclarationTypeEnum obj : DeclarationTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
