package cn.com.servyou.dto.enums;

import java.util.Objects;

/**
 * @author ranjh
 * @since 20230420
 */
public enum DeclareEmployeeStrategy {
    YES("是", "人员信息有改动才会进行人员报送"),
    NO("否", "无需关注人员信息是否有改动，强制人员报送");

    private String code;

    private String desc;

    DeclareEmployeeStrategy(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DeclareEmployeeStrategy getByCode(String code) {
        for (DeclareEmployeeStrategy obj : DeclareEmployeeStrategy.values()) {
            if (Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static DeclareEmployeeStrategy getByDesc(String desc) {
        for (DeclareEmployeeStrategy obj : DeclareEmployeeStrategy.values()) {
            if (Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
