package cn.com.servyou.dto.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 允许列支的捐赠比例
 *
 * @author zhouq
 */
public enum DonationProportionEnum {

    /**
     * 0.3 限额扣除
     */
    THIRTY_PERCENTAGE("1", "限额扣除"),
    /**
     * 1 全额扣除
     */
    ONE_HUNDRED_PERCENTAGE("2", "全额扣除"),
    /**
     * 混合
     */
    MIXED_PERCENTAGE("3", "混合");

    private static final Map<String, DonationProportionEnum> PROPORTION_CODE_MAP = new HashMap<>();

    private static final Map<String, DonationProportionEnum> PROPORTION_DESC_MAP = new HashMap<>();


    static {
        for (DonationProportionEnum DonationProportionEnum : DonationProportionEnum
                .values()) {
            PROPORTION_CODE_MAP.put(
                    DonationProportionEnum.getCode(),
                    DonationProportionEnum);
        }
    }

    static {
        for (DonationProportionEnum DonationProportionEnum : DonationProportionEnum
                .values()) {
            PROPORTION_DESC_MAP.put(
                    DonationProportionEnum.getDesc(),
                    DonationProportionEnum);
        }
    }

    private String code;

    private String desc;


    DonationProportionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DonationProportionEnum getByCode(String key) {
        if (PROPORTION_CODE_MAP.get(key) == null) {
            return DonationProportionEnum.THIRTY_PERCENTAGE;
        }
        return PROPORTION_CODE_MAP.get(key);
    }

    public static DonationProportionEnum getByDesc(String desc) {
        return PROPORTION_DESC_MAP.get(desc);
    }

    /**
     * 判断传入的code是否属于枚举中的一员
     *
     * @param code
     * @return
     */
    public static boolean isBelongAllowedDonationProportion(String code) {
        if (PROPORTION_CODE_MAP.get(code) == null) {
            return false;
        }
        return true;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


}
