package cn.com.servyou.dto.enums;

import cn.com.servyou.utils.StringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 学历枚举
 *
 * @author zhouww
 * @version 20191024
 */
public enum EmpEducationTypeEnum {
    POSTGRADUATE("10", "研究生"),
    UNDERGRADUATE("20", "大学本科"),
    BELOW_UNDERGRADUATE("30", "大学本科以下");

    private String code;

    private String desc;

    private static final Map<String, EmpEducationTypeEnum> EDUCATION_TYPE_ENUM_CODE_MAP = new HashMap<>();

    private static final Map<String, EmpEducationTypeEnum> EDUCATION_TYPE_ENUM_DESC_MAP = new HashMap<>();

    static {
        for (EmpEducationTypeEnum educationTypeEnum : EmpEducationTypeEnum.values()) {
            EDUCATION_TYPE_ENUM_CODE_MAP.put(educationTypeEnum.getCode(), educationTypeEnum);
            EDUCATION_TYPE_ENUM_DESC_MAP.put(educationTypeEnum.getDesc(), educationTypeEnum);
        }
    }

    EmpEducationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EmpEducationTypeEnum getByCode(String code) {
        return EDUCATION_TYPE_ENUM_CODE_MAP.get(code);
    }

    public static EmpEducationTypeEnum getByDesc(String desc) {
        return EDUCATION_TYPE_ENUM_DESC_MAP.get(desc);
    }

    public static String getCodeByDesc(String desc) {
        if (StringUtil.isNotBlank(desc)) {
            EmpEducationTypeEnum empEducationTypeEnum = getByDesc(desc);
            if (null != empEducationTypeEnum) {
                return empEducationTypeEnum.getCode();
            }
        }
        return null;
    }
}
