package cn.com.servyou.dto.enums;

import cn.com.servyou.utils.StringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 职务级别枚举
 *
 * @author yinf
 * @version $$Id: EmpPostLevelEnum, v 0.1 2018-11-19 22:24 yinf Exp $$
 */
public enum EmpPostLevelEnum {
    SENIOR("1", "高层"),
    //    MEDIUM("2", "中层"),
    ORDINARY("3", "普通");

    private String code;

    private String desc;

    private static final Map<String, EmpPostLevelEnum> POST_LEVEL_ENUM_CODE_MAP = new HashMap<>();

    private static final Map<String, EmpPostLevelEnum> POST_LEVEL_ENUM_DESC_MAP = new HashMap<>();

    static {
        for (EmpPostLevelEnum empPostLevelEnum : EmpPostLevelEnum.values()) {
            POST_LEVEL_ENUM_CODE_MAP.put(empPostLevelEnum.getCode(), empPostLevelEnum);
            POST_LEVEL_ENUM_DESC_MAP.put(empPostLevelEnum.getDesc(), empPostLevelEnum);
        }
    }

    EmpPostLevelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EmpPostLevelEnum getByCode(String code) {
        return POST_LEVEL_ENUM_CODE_MAP.get(code);
    }

    public static EmpPostLevelEnum getByDesc(String desc) {
        return POST_LEVEL_ENUM_DESC_MAP.get(desc);
    }

    public static String getCodeByDesc(String desc) {
        if (StringUtil.isNotBlank(desc)) {
            EmpPostLevelEnum empPostLevelEnum = getByDesc(desc);
            if (null != empPostLevelEnum) {
                return empPostLevelEnum.getCode();
            }
        }
        return null;
    }
}
