package cn.com.servyou.dto.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhouww
 * @since 20190829
 */
public enum EmployeeAreaEnum {
    ALL("0", "全部"),
    DOMESTIC("1", "境内"),
    ABROAD("2", "境外");

    private static final Map<String, EmployeeAreaEnum> EMP_AREA_ENUM_DESC_MAP = new HashMap<>();

    static {
        for (EmployeeAreaEnum employeeAreaEnum : EmployeeAreaEnum.values()) {
            EMP_AREA_ENUM_DESC_MAP.put(employeeAreaEnum.getDesc(), employeeAreaEnum);
        }
    }

    private String code;

    private String desc;

    EmployeeAreaEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getCodeByDesc(String desc) {
        if (ABROAD.getDesc().equals(desc)) {
            return ABROAD.getCode();
        } else {
            return DOMESTIC.getCode();
        }
    }

    public static EmployeeAreaEnum getByCode(String code) {
        if (DOMESTIC.getCode().equals(code)) {
            return DOMESTIC;
        } else if (ABROAD.getCode().equals(code)) {
            return ABROAD;
        } else {
            return null;
        }
    }
}
