package cn.com.servyou.dto.enums;

import cn.com.servyou.utils.StringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhouww
 * @since 20190829
 */
public enum EmployeeLicenseTypeEnum {
    RESIDENT_IDENTITY_CARD("201", "居民身份证", "居民身份证", EmployeeAreaEnum.DOMESTIC.getCode()),
    FOREIGN_PASSPORT("208", "外国护照", "外国护照", EmployeeAreaEnum.ABROAD.getCode()),
    CHINESE_PASSPORT("227", "中国护照", "中国护照", EmployeeAreaEnum.ABROAD.getCode()),
    MAINLAND_PERMIT_FOR_HONGKONG_AND_MACAO("210", "港澳居民来往内地通行证", "港澳居民来往内地通行证", EmployeeAreaEnum.ABROAD.getCode()),
    MAINLAND_PERMIT_FOR_TAIWAN("213", "台湾居民来往大陆通行证", "台湾居民来往大陆通行证", EmployeeAreaEnum.ABROAD.getCode()),
    PERMANENT_RESIDENCE_PERMIT_FOR_FOREIGNERS("233", "外国人永久居留身份证（外国人永久居留证）", "外国人永久居留身份证", EmployeeAreaEnum.ABROAD.getCode()),
    RESIDENCE_PERMIT_FOR_HONGKONG_AND_MACAO("237", "中华人民共和国港澳居民居住证", "港澳居民居住证", EmployeeAreaEnum.ABROAD.getCode()),
    RESIDENCE_PERMIT_FOR_TAIWAN("238", "中华人民共和国台湾居民居住证", "台湾居民居住证", EmployeeAreaEnum.ABROAD.getCode()),
    WORK_PERMIT_A_FOR_FOREIGNERS("239", "《中华人民共和国外国人工作许可证》（A类）", "外国人工作许可证（A类）", EmployeeAreaEnum.ABROAD.getCode()),
    WORK_PERMIT_B_FOR_FOREIGNERS("240", "《中华人民共和国外国人工作许可证》（B类）", "外国人工作许可证（B类）", EmployeeAreaEnum.ABROAD.getCode()),
    WORK_PERMIT_C_FOR_FOREIGNERS("241", "《中华人民共和国外国人工作许可证》（C类）", "外国人工作许可证（C类）", EmployeeAreaEnum.ABROAD.getCode()),
    OTHER("299", "其他个人证件", "其他个人证件", EmployeeAreaEnum.ABROAD.getCode());

    private String code;

    private String desc;

    private String shortDesc;

    private String area;

    EmployeeLicenseTypeEnum(String code, String desc, String shortDesc, String area) {
        this.code = code;
        this.desc = desc;
        this.shortDesc = shortDesc;
        this.area = area;
    }

    public String getShortDesc() {
        return shortDesc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getArea() {
        return area;
    }

    private static final Map<String, EmployeeLicenseTypeEnum> LICENSE_TYPE_ENUM_CODE_MAP = new HashMap<>();

    private static final Map<String, EmployeeLicenseTypeEnum> LICENSE_TYPE_ENUM_SHORTDESSC_MAP = new HashMap<>();

    static {
        for (EmployeeLicenseTypeEnum employeeLicenseTypeEnum : EmployeeLicenseTypeEnum.values()) {
            LICENSE_TYPE_ENUM_CODE_MAP.put(employeeLicenseTypeEnum.getCode(), employeeLicenseTypeEnum);
        }
    }

    public static EmployeeLicenseTypeEnum getByCode(String code) {
        if (LICENSE_TYPE_ENUM_CODE_MAP.get(code) == null) {
            return null;
        }
        return LICENSE_TYPE_ENUM_CODE_MAP.get(code);
    }

    public static EmployeeLicenseTypeEnum getByName(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        for (EmployeeLicenseTypeEnum employeeLicenseTypeEnum : EmployeeLicenseTypeEnum.values()) {
            if (employeeLicenseTypeEnum.getDesc().equals(name)) {
                return employeeLicenseTypeEnum;
            }
        }
        return null;
    }

    private static final Map<String, EmployeeLicenseTypeEnum> LICENSE_TYPE_ENUM_DESC_MAP = new HashMap<>();

    static {
        for (EmployeeLicenseTypeEnum employeeLicenseTypeEnum : EmployeeLicenseTypeEnum.values()) {
            LICENSE_TYPE_ENUM_DESC_MAP.put(employeeLicenseTypeEnum.getDesc(), employeeLicenseTypeEnum);
            LICENSE_TYPE_ENUM_SHORTDESSC_MAP.put(employeeLicenseTypeEnum.getShortDesc(), employeeLicenseTypeEnum);
        }

    }

    public static EmployeeLicenseTypeEnum getByDesc(String desc) {
        return LICENSE_TYPE_ENUM_DESC_MAP.get(desc);
    }

    public static String getCodeByDesc(String desc) {
        if (StringUtil.isNotBlank(desc)) {
            EmployeeLicenseTypeEnum employeeLicenseTypeEnum = getByShortDesc(desc);
            if (null != employeeLicenseTypeEnum) {
                return employeeLicenseTypeEnum.getCode();
            }
        }
        return null;
    }

    public static EmployeeLicenseTypeEnum getByShortDesc(String shortDesc) {
        return LICENSE_TYPE_ENUM_SHORTDESSC_MAP.get(shortDesc);
    }
}
