package cn.com.servyou.dto.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Robin Wang  on 2018/11/19.
 */
public enum FamilyMemberRelationshipEnum {

    SELF("0", "本人或户主"),
    SPOUSES("1", "配偶"),
    SON("2", "子"),
    DAUGHTER("3", "女"),
    LITTLE_BOY_AND_GIRL("4", "孙子、孙女或外孙子、外孙女"),
    PARENT("5", "父母"),
    GRANDPARENT("6", "祖父母或外祖父母"),
    SISTER_BROTHER("7", "兄、弟、姐、妹"),
    OTHERS("8", "其他");

    private String code;

    private String desc;

    private static Map<String, FamilyMemberRelationshipEnum> RELATIONSHIP_CODE_MAP = new HashMap<>();

    private static Map<String, FamilyMemberRelationshipEnum> RELATIONSHIP_DESC_MAP = new HashMap<>();

    static {
        for (FamilyMemberRelationshipEnum obj : FamilyMemberRelationshipEnum.values()) {
            RELATIONSHIP_CODE_MAP.put(obj.getCode(), obj);
            RELATIONSHIP_DESC_MAP.put(obj.getDesc(), obj);
        }
    }

    FamilyMemberRelationshipEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static FamilyMemberRelationshipEnum getByCode(String code) {

        return RELATIONSHIP_CODE_MAP.get(code) == null ? null : RELATIONSHIP_CODE_MAP.get(code);
    }

    public static FamilyMemberRelationshipEnum getByDesc(String desc) {
        return RELATIONSHIP_DESC_MAP.get(desc) == null ? null : RELATIONSHIP_DESC_MAP.get(desc);
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
