package cn.com.servyou.dto.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 公式枚举
 *
 * @author yinf
 * @version $$Id: FormulaEnum, v 0.1 2019-04-09 12:00 yinf Exp $$
 */
public enum FormulaEnum {
    FORMULA_ONE("0", "公式(1)不超过90天(非高管)"),
    FORMULA_TWO("1", "公式(4)不超过90天(高管)"),
    FORMULA_THREE("2", "公式(2)超过90天不满183天(非高管)"),
    FORMULA_FOUR("3", "公式(3)超过90天不满183天(高管)"),
    FORMULA_FIVE("4", "公式(1)税收协定居民不超过183天"),
    FORMULA_SIX("5", "公式(3)满183天的年度连续不满六年"),
    FORMULA_SEVEN("6", "公式(2)税收协定居民超过183天，但满183天的年度连续不满六年"),
    FORMULA_EIGHT("7", "公式(5)满183天的年度连续满六年"),
    FORMULA_NINE("8", "公式(5)有住所居民");

    private static final Map<String, FormulaEnum> FORMULA_ENUM_CODE_MAP = new HashMap<>();

    private static final Map<String, FormulaEnum> FORMULA_ENUM_DESC_MAP = new HashMap<>();

    static {
        for (FormulaEnum formulaEnum : FormulaEnum.values()) {
            FORMULA_ENUM_CODE_MAP.put(formulaEnum.getCode(), formulaEnum);
            FORMULA_ENUM_DESC_MAP.put(formulaEnum.getDesc(), formulaEnum);
        }
    }

    private String code;

    private String desc;

    FormulaEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static FormulaEnum getByCode(String code) {
        if (null != FORMULA_ENUM_CODE_MAP.get(code)) {
            return FORMULA_ENUM_CODE_MAP.get(code);
        }
        return null;
    }

    public static String getCodeByDesc(String desc) {
        if (null != FORMULA_ENUM_DESC_MAP.get(desc)) {
            return FORMULA_ENUM_DESC_MAP.get(desc).getCode();
        }
        return null;
    }
}
