package cn.com.servyou.dto.enums;

/**
 * 房屋证书类型枚举
 *
 * @author Robin Wang  on 2018-12-05.
 */
public enum HouseCertificateTypeEnum {

    CERTIFICATE_OF_OWNERSHIP("01", "房屋所有权证"),
    UN_CHANGE_HOUSE_PEOPERTY("02", "不动产权证"),
    HOUSE_DEAL_CONTRACT("03", "房屋买卖合同"),
    HOUSE_PRE_SALE_CONTRACT("04", "房屋预售合同");

    private String code;

    private String desc;

    HouseCertificateTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HouseCertificateTypeEnum getByCode(String code) {
        for (HouseCertificateTypeEnum obj : HouseCertificateTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static HouseCertificateTypeEnum getByDesc(String desc) {
        for (HouseCertificateTypeEnum obj : HouseCertificateTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
