package cn.com.servyou.dto.enums;

/**
 * 房屋贷款类型枚举
 *
 * @author Robin Wang  on 2018/11/26.
 */
public enum HouseLoanTypeEnum {

    PROVIDENT_LOAN("1", "公积金贷款"),
    COMMERCE_LOAN("2", "商业贷款"),
    GROUP_LOAN("3", "组合贷款");

    private String code;

    private String desc;

    HouseLoanTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HouseLoanTypeEnum getByCode(String code) {
        for (HouseLoanTypeEnum obj : HouseLoanTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static HouseLoanTypeEnum getByDesc(String desc) {
        for (HouseLoanTypeEnum obj : HouseLoanTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
