package cn.com.servyou.dto.enums;


import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * 报表列表
 *
 * @author zhouww
 * @since 20191024
 */

public enum IncomeItemEnum {
    ALL(0, "0", "0", "全部所得项"),
    NORMAL_SALARIES(1, "0101", "101060100", "正常工资薪金"),
    ABROAD(1, "0102", "101060100", "外籍人员正常工资薪金"),
    BONUS(1, "0103", "101060100", "全年一次性奖金收入"),
    MONTHS_BONUS(1, "0104", "101060100", "外籍人员数月奖金"),
    RETREAT(1, "0107", "101060100", "内退一次性补偿金"),
    COMPENSATE(1, "0108", "101060100", "解除劳动合同一次性补偿金"),
    EQUITY_INCENTIVE(1, "0109", "101060100", "个人股权激励收入"),
    ANNUITY_RECEIPT(1, "0110", "101060100", "年金领取"),
    PRODUCT(2, "0200", "101060200", "个体工商户生产经营所得"),
    LABOR(4, "0401", "101060400", "一般劳务报酬所得"),
    INSURANCE_SALESMEN(1, "0402", "101060400", "保险营销员佣金收入"),
    SECURITIES_BROKER(1, "0403", "101060400", "证券经纪人佣金收入"),
    ROYALTIES(5, "0500", "101060500", "稿酬所得"),
    CONCESSION(6, "0600", "101060600", "特许权使用费所得"),
    LISTED_COMPANY_INTEREST(7, "0701", "101060700", "上市公司股息红利所得（沪市、深市、创业板）"),
    INTEREST(7, "0799", "101060799", "其他利息、股息、红利所得"),
    PROPERTY_RENTAL(8, "0800", "101060800", "财产租赁所得"),
    OTHER_PROPERTY_RENTAL(1, "0899", "101060899", "其他财产租赁所得"),
    PROPERTY_TRANSFER(9, "0900", "101060900", "财产转让所得"),
    EQUITY(9, "0905", "101060999", "股权转让所得"),
    PROPERTY(9, "0999", "101060999", "其他财产转让所得"),
    STOCK(10, "0901", "101060999", "股票转让所得"),
    HOUSING_TRANSFER(11, "0902", "101060902", "个人房屋转让所得"),
    HAPHAZARD(12, "1099", "101061000", "其他偶然所得");
    ;

    /**
     * 已经支持的其他所得报表集合
     */
    private static final Set<IncomeItemEnum> OTHER_REPORT_SET = new HashSet<>(
            Arrays.asList(COMPENSATE, ROYALTIES, EQUITY, PROPERTY, HAPHAZARD));

    private static final Map<String, IncomeItemEnum> INCOME_ITEM_CODE_ENUM_MAP = new HashMap<>();

    static {
        for (IncomeItemEnum itemCode : IncomeItemEnum.values()) {
            INCOME_ITEM_CODE_ENUM_MAP.put(String.valueOf(itemCode.getCode()), itemCode);
        }
    }

    private static final Map<String, IncomeItemEnum> INCOME_ITEM_NAME_ENUM_MAP = new HashMap<>();

    static {
        for (IncomeItemEnum itemCode : IncomeItemEnum.values()) {
            INCOME_ITEM_NAME_ENUM_MAP.put(itemCode.getName(), itemCode);
        }
    }

    private int index;

    private String code;

    private String zspmdm;

    private String name;

    IncomeItemEnum(int index, String code, String zspmdm, String name) {
        this.index = index;
        this.code = code;
        this.zspmdm = zspmdm;
        this.name = name;
    }

    public static IncomeItemEnum getByCode(String code) {
        if (null == INCOME_ITEM_CODE_ENUM_MAP.get(code)) {
            return IncomeItemEnum.NORMAL_SALARIES;
        }
        return INCOME_ITEM_CODE_ENUM_MAP.get(code);
    }

    /**
     * 没有默认值的返回
     *
     * @param code
     * @return
     */
    public static IncomeItemEnum getByCodeNotDefault(String code) {
        return INCOME_ITEM_CODE_ENUM_MAP.get(code);
    }

    public static IncomeItemEnum getByName(String name) {
        return INCOME_ITEM_NAME_ENUM_MAP.get(name);
    }

    public int getIndex() {
        return index;
    }

    public String getCode() {
        return code;
    }

    public String getZspmdm() {
        return zspmdm;
    }

    public String getName() {
        return name;
    }

    public static Set<IncomeItemEnum> getOtherReportSet() {
        return OTHER_REPORT_SET;
    }
}
