package cn.com.servyou.dto.enums;

import java.util.Objects;

/**
 * 个人养老金策略
 *
 * @author ranjh
 * @since 20210729
 */
public enum PersonalPensionOptionEnum {
    DEFAULT("0", "使用下载的个人养老金"),
    LOCAL("1", "使用本地的个人养老金");

    private String code;

    private String msg;

    PersonalPensionOptionEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static PersonalPensionOptionEnum getByCode(String code) {
        for (PersonalPensionOptionEnum obj : PersonalPensionOptionEnum.values()) {
            if (Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static PersonalPensionOptionEnum getByMsg(String msg) {
        for (PersonalPensionOptionEnum obj : PersonalPensionOptionEnum.values()) {
            if (Objects.equals(obj.msg, msg)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
