package cn.com.servyou.dto.enums;

/**
 * 住房租金专项扣除出租方类型枚举
 *
 * @author Robin Wang  on 2018-12-06.
 */
public enum RentTypeEnum {

    PERSONAL("0", "个人"),
    COMPANY("1", "组织");

    private String code;

    private String desc;

    RentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RentTypeEnum getByCode(String code) {
        for (RentTypeEnum obj : RentTypeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static RentTypeEnum getByDesc(String desc) {
        for (RentTypeEnum obj : RentTypeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
