package cn.com.servyou.dto.enums;

/**
 * 赡养老人专项扣除分摊方式枚举
 *
 * @author Robin Wang  on 2018-12-06.
 */
public enum SupportElderModeEnum {

    AVG_SHARE("1", "赡养人平均分摊"),
    APPOINT_SHARE("2", "赡养人约定分摊"),
    ORDER_SHARE("3", "被赡养人指定分摊");

    private String code;

    private String desc;

    SupportElderModeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SupportElderModeEnum getByCode(String code) {
        for (SupportElderModeEnum obj : SupportElderModeEnum.values()) {
            if (java.util.Objects.equals(obj.code, code)) {
                return obj;
            }
        }
        return null;
    }

    public static SupportElderModeEnum getByDesc(String desc) {
        for (SupportElderModeEnum obj : SupportElderModeEnum.values()) {
            if (java.util.Objects.equals(obj.desc, desc)) {
                return obj;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
