package cn.com.servyou.dto.invoice;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 开票结果查询 结果VO
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class GetInvoiceBillingApplyResultVO {
    /**
     * 申请流水号
     */
    private String sqlsh;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 发票类型
     */
    private String fplx;

    /**
     * 开票金额
     */
    private BigDecimal kpje;

    /**
     * 开票税额
     */
    private BigDecimal kpse;

    /**
     * 销方纳税人识别号
     */
    private String xfnsrsbh;

    /**
     * 销方纳税人名称
     */
    private String xfnsrmc;

    /**
     * 购方纳税人识别号
     */
    private String gfnsrsbh;

    /**
     * 购方纳税人名称
     */
    private String gfnsrmc;

    /**
     * 开票提交时间
     */
    private String kptjsj;

    /**
     * 开票完成时间
     */
    private String kpwcsj;

    /**
     * 开票状态 ACCEPT-接收开票请求;SUCCESS-开票成功;FAILED-开票失败;QUERY_FAILED-已开票，查询失败;TIMEOUT-开票超时
     */
    private String kpzt;

    /**
     * 错误信息
     */
    private String cwxx;

    /**
     * 发票信息
     */
    private InvoiceResultVO fpxx;
}
