package cn.com.servyou.dto.invoice;

import lombok.Data;

import java.util.List;

/**
 * 开票申请 请求VO
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class InvoiceBillingApplyRequestVO extends InvoiceBaseRequestVO {
    /**
     * 平台id
     */
    private String platformId;

    /**
     * 税盘号
     */
    private String sph;

    /**
     * 开票来源（YQDZ/ETS）
     */
    private String billingSource;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 发票类型
     */
    private String fplx;

    /**
     * 票面金额
     */
    private String kpje;

    /**
     * 票面税额
     */
    private String kpse;

    /**
     * 价税合计
     */
    private String jshj;

    /**
     * 销方纳税人识别号
     */
    private String xfnsrsbh;

    /**
     * 销方纳税人名称
     */
    private String xfnsrmc;

    /**
     * 购方纳税人识别号
     */
    private String gfnsrsbh;

    /**
     * 购方纳税人名称
     */
    private String gfnsrmc;

    /**
     * 开票日期
     */
    private String kprq;

    /**
     * 红字发票标志1--红字，0--非红字
     */
    private String hzfpbz;

    /**
     * 备注
     */
    private String bz;

    /**
     * 推送邮箱
     */
    private String tsyx;

    /**
     * 销方地址、电话
     */
    private String xfdzdh;

    /**
     * 销方开户行及账号
     */
    private String xfkhhjzh;

    /**
     * 购方地址、电话
     */
    private String gfdzdh;

    /**
     * 购方开户行及账号
     */
    private String gfkhhjzh;

    /**
     * 收款人
     */
    private String skr;

    /**
     * 复核人
     */
    private String fhr;

    /**
     * 开票人
     */
    private String kpr;

    /**
     * 红字信息表通知单号
     */
    private String tzdbh;

    /**
     * 对应蓝字发票代码
     */
    private String dylzfpdm;

    /**
     * 对应蓝字发票号码
     */
    private String dylzfphm;

    /**
     * 原发票类型，选填
     */
    private String yfplx;

    /**
     * 原开票日期，选填
     */
    private String ykprq;

    /**
     * 货物信息
     */
    private List<InvoiceBillingCargoVO> hwxxlb;

}
