package cn.com.servyou.dto.invoice;

import lombok.Data;

/**
 * 发票货物信息 结果VO
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class InvoiceCargoResultVO {
    /**
     * 行号
     */
    private Integer hh;

    /**
     * 货物名称
     */
    private String hwmc;

    /**
     * 商品税目名称
     */
    private String spsm;

    /**
     * 原始的商品名称
     */
    private String ysspmc;

    /**
     * 规格型号
     */
    private String ggxh;

    /**
     * 单位
     */
    private String dw;

    /**
     * 单价
     */
    private String dj;

    /**
     * 数量
     */
    private String sl;

    /**
     * 不含税金额
     */
    private String bhsje;

    /**
     * 税额
     */
    private String se;

    /**
     * 税率
     */
    private String slv;

    /**
     * 商品编码
     */
    private String spbm;

    /**
     * 优惠政策类型:1：免税，2：不征税
     */
    private String yhzclx;

    /**
     * 是否享受优惠政策:0：不享受，1：享受
     */
    private String sfxsyhzc;

    /**
     * 免税类型:1：正常税率，3：普通零税率
     * <p>
     * -1-非零税率；0-出口退税；1-免税；2-不征收；3-普通零税率
     */
    private String mslx;

    /**
     * 征税方式:0：普通征税，1：减按计征，2：差额征税
     */
    private String zsfs;

    /**
     * 发票行性质:0 - 正常行，1 - 折扣行, 2 - 被折扣行, 3 - (详见销货清单)
     */
    private String fphxz;

    /**
     * 含税标志0--不含税，1--含税
     */
    private String hsbz;
}
