package cn.com.servyou.dto.invoice;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author sunjl
 * @since 20220922
 */
@Data
public class InvoiceCargoVO {

    /**
     * 行号
     */
    private Integer hh;

    /**
     * 货物名称
     */
    private String hwmc;

    /**
     * 规格型号
     */
    private String ggxh;

    /**
     * 税收分类编码
     */
    private String ssflbm;

    /**
     * 金额
     */
    private BigDecimal je;

    /**
     * 税率
     */
    private BigDecimal sl;

    /**
     * 税额
     */
    private BigDecimal se;

    /**
     * 数量
     */
    private BigDecimal shul;

    /**
     * 单价
     */
    private BigDecimal dj;

    /**
     * 单位
     */
    private String dw;

    /**
     * 含税标志
     */
    private Integer hsbz;

    /**
     * 行性质
     */
    private Integer hxz;

    /**
     * 零税率标识： 空代表无；0-出口退税；1-出口免税和其他免税优惠政策；2-不征增值税；3-普通零税率
     * 该值不一定准确
     */
    private String lslbs;
}
