package cn.com.servyou.dto.invoice;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author sunjl
 * @since 20220922
 */
@Data
public class InvoiceComplementVO {

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 发票类型
     */
    private Integer fplx;

    /**
     * 开票日期
     */
    private Date kprq;

    /**
     * 销方税号
     */
    private String xfsh;

    /**
     * 销方名称
     */
    private String xfmc;

    /**
     * 购方税号
     */
    private String gfsh;

    /**
     * 购方名称
     */
    private String gfmc;

    /**
     * 开票机号
     */
    private String kpjh;

    /**
     * 开票金额
     */
    private BigDecimal jpje;

    /**
     * 开票税额
     */
    private BigDecimal jpse;

    /**
     * 作废标志:0 不是；1 是
     */
    private Integer zfbz;

    /**
     * 购货方证件号码
     */
    private String ghfzjhm;

    /**
     * 机打代码
     */
    private String jddm;

    /**
     * 机打号码
     */
    private String jdhm;

    /**
     * 机器编码
     */
    private String jqbm;

    /**
     * 开票税率：机动车发票包含此值
     */
    private String kpsl;

    /**
     * 车辆类型
     */
    private String cllx;

    /**
     * 厂牌型号
     */
    private String cpxh;

    /**
     * 产地
     */
    private String cd;

    /**
     * 合格证
     */
    private String hgz;

    /**
     * 进口证明书号
     */
    private String jkzmsh;

    /**
     * 商检单号
     */
    private String sjdh;

    /**
     * 发动机号码
     */
    private String fdjhm;

    /**
     * 车辆识别代码
     */
    private String clsbdm;

    /**
     * 吨位
     */
    private String dw;

    /**
     * 限坐人数
     */
    private String xzrs;

    /**
     * 税务机关代码
     */
    private String swjgdm;

    /**
     * 税务机关名称
     */
    private String swjgmc;

    /**
     * 密文
     */
    private String mw;

    /**
     * 校验码
     */
    private String jym;

    /**
     * 正数发票代码
     */
    private String zsfpdm;

    /**
     * 正数发票号码
     */
    private String zsfphm;

    /**
     * 销方银行账号和名称
     */
    private String xfyhzhmc;

    /**
     * 销方地址和电话
     */
    private String xfdzdh;

    /**
     * 销方电话
     */
    private String xfdh;

    /**
     * 销方地址
     */
    private String xfdz;

    /**
     * 销方银行账号
     */
    private String xfyhzh;

    /**
     * 销方银行名称
     */
    private String xfyhmc;

    /**
     * 购方银行账号和名称
     */
    private String gfyhzhmc;

    /**
     * 购方地址和电话;
     */
    private String gfdzdh;

    /**
     * 认证月份
     */
    private String rzyf;

    /**
     * 认证时间
     */
    private Date rzsj;

    /**
     * 认证状态
     */
    private Integer rzzt;

    /**
     * 抵扣状态
     */
    private String dkzt;

    /**
     * 抵扣时间
     */
    private Date dksj;

    /**
     * 抵扣月份
     */
    private String dkyf;

    /**
     * 勾选状态
     */
    private String gxzt;

    /**
     * 勾选时间
     */
    private Date gxsj;

    /**
     * 确认状态
     */
    private String qrzt;

    /**
     * 确认时间
     */
    private Date qrsj;

    /**
     * 勾选来源
     */
    private String gxly;

    /**
     * 认证渠道
     */
    private String rzqd;

    /**
     * 发票状态
     */
    private String fpzt;

    /**
     * 补齐状态
     */
    private Integer bqzt;

    /**
     * 备注信息
     */
    private String bzxx;

    /**
     * 修改时间
     */
    private Date xgsj;

    /**
     * 商品税目编码
     */
    private String spshbm;

    /**
     * 收款人
     */
    private String skr;

    /**
     * 开票人
     */
    private String kpr;

    /**
     * 复核人
     */
    private String fhr;

    /**
     * 差额标志
     */
    private Integer cebz;

    /**
     * 来源
     */
    private Integer ly;

    /**
     * 红票标志 0-非红票 1-红票（该字段为计算字段，不建议使用）
     */
    private Integer hpbz;

    /**
     * 有效发票税额
     */
    private BigDecimal yxfpse;

    /**
     * 代开标志 0非代开 1代开 会存在null的情况
     */
    private String dkbz;

    /**
     * 货物信息
     */
    private List<InvoiceCargoVO> hwxxlb;
}
