package cn.com.servyou.dto.invoice;

import lombok.Data;

import java.util.List;

/**
 * 发票申领状态查询--出参
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class InvoiceQueryApplyStatusResultGroupVO {
    /**
     * 发票类型  --  026-增值税电子普通发票；028-增值税电子专用发票
     */
    private String fplx;

    /**
     * 发票种类代码  --  11-增值税电子普通发票; 13-增值税电子专用发票
     */
    private String fpzl;

    /**
     * 申领序号
     */
    private String slxh;

    /**
     * 申领数量
     */
    private String slsl;

    /**
     * 申领时间  --  格式：yyyymmdd
     */
    private String slsj;

    /**
     * 处理状态  --  1：成功  2：失败  0：申领中
     */
    private String clzt;

    /**
     * 处理信息 -- 如果发售失败，此为失败原因
     */
    private String clxx;

    /**
     * 处理时间  --  格式：yyyymmdd
     */
    private String clsj;

    /**
     * 预申请编号
     */
    private String ysqbh;

    /**
     * 结果确认标志 (纸票确认接收  Y：已确认  N：未确认)
     */
    private String jgqrbz;

    /**
     * 申领结果明细
     */
    private List<InvoiceQueryApplyStatusResultGroupDetailVO> sljglb;
}
