package cn.com.servyou.dto.invoice;

import lombok.Data;

/**
 * 分页查询发票 请求VO
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class QueryInvoicePageRequestVO extends InvoiceBaseRequestVO {
    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 开票起始日期
     * yyyyMMdd
     */
    private String kpqsrq;

    /**
     * 开票截止日期
     * yyyyMMdd
     */
    private String kpjzrq;

    /**
     * 分页参数
     */
    private int pageNo = 1;

    /**
     * 分页大小，建议25，最大100
     */
    private int pageSize = 25;
}
