package cn.com.servyou.dto.invoice;

import lombok.Data;

import java.util.List;

/**
 * 红字申请提交 请求VO
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class RedInvoiceApplySubmitRequestVO extends InvoiceBaseRequestVO {
    /**
     * 业务流水号
     */
    private String ywqqlsh;

    /**
     * 购方名称
     */
    private String gfnsrmc;

    /**
     * 购方纳税人税号
     */
    private String gfnsrsbh;

    /**
     * 销方名称
     */
    private String xfnsrmc;

    /**
     * 销方纳税人识别号
     */
    private String xfnsrsbh;

    /**
     * 开票金额
     */
    private String kpje;

    /**
     * 开票税额
     */
    private String kpse;

    /**
     * 原始发票代码
     */
    private String ysfpdm;

    /**
     * 原始发票号码
     */
    private String ysfphm;

    /**
     * 开票日期 yyyy-MM-dd HH:mm:ss
     */
    private String kprq;

    /**
     * 申请理由代码
     * 0：已抵扣（购方申请），
     * 1：未抵扣（购方申请），
     * 2：销方申请（销方申请）
     */
    private String sqlydm;

    /**
     * 申请方式: 0-全部红冲, 1-部分红冲
     */
    private String sqfs;

    /**
     * 征税方式: 0-普通征税  1-减按计征 2-差额征税
     */
    private String zsfs;

    /**
     * 红字申请清单明细
     */
    private List<RedInvoiceApplyDetailRequestVO> hwxxlb;
}
