package cn.com.servyou.dto.invoice;

import lombok.Data;

/**
 * 同步历史发票 请求VO
 *
 * @author rjq
 * @since 20220526
 */
@Data
public class SyncHistoryInvoiceRequestVO extends InvoiceBaseRequestVO {
    /**
     * 发票类型  --  026-增值税电子普通发票；028-增值税电子专用发票
     */
    private String fplx;

    /**
     * 查询类型
     * 0：按发票代码、号码查询（号码范围不能超过1000）；
     * 1：按时间范围查询（时间范围小于90天）；
     */
    private String cxlx;

    /**
     * 发票代码，查询类型为0时必填
     */
    private String fpdm;

    /**
     * 发票起始号码，查询类型为0时必填
     */
    private String fpqshm;

    /**
     * 发票截止号码，查询类型为0时必填
     */
    private String fpjzhm;

    /**
     * 查询起始日期，查询类型为1时必填，yyyyMMdd
     */
    private String cxqsrq;

    /**
     * 查询截止日期，查询类型为1时必填，yyyyMMdd
     */
    private String cxjzrq;

    /**
     * 是否设备查询
     * <p>
     * 1-供应商库查询（默认） 2-设备里查询
     */
    private Boolean sfsbcx;
}
