package cn.com.servyou.dto.invoice;

import lombok.Data;

/**
 * 税盘信息VO
 *
 * @author sunjl
 * @since 20220428
 */
@Data
public class TaxPlateResultVO {

    /**
     * 税盘号
     */
    private String sph;

    /**
     * 税盘类型：0：未知，1：金税盘，2：税控盘，3：模拟盘，4：ca/ukey，5：虚拟盘，101：税务ukey
     */
    private String splx;

    /**
     * 机柜号
     */
    private String jgbh;

    /**
     * 端口号
     */
    private String dkh;

    /**
     * 初始化状态：0：未完成，1：已完成
     */
    private Integer cshzt;

    /**
     * 错误信息
     */
    private String cwxx;

    /**
     * 末次在线时刻 yyyyMMddHHmm
     */
    private String mczxsk;

    /**
     * 纳税人识别号
     */
    private String nsrshb;

    /**
     * 纳税人识别号
     */
    private String nsrsbh;

    /**
     * 纳税人名称
     */
    private String nsrmc;

    /**
     * 分机号
     */
    private String fjh;

    /**
     * 税务机关代码
     */
    private String swjgdm;

    /**
     * 税务机关名称
     */
    private String swjgmc;

    /**
     * 服务开通状态 0：未开通，1：已开通
     */
    private Integer fwktzt;

    /**
     * 服务授权状态 0：未授权，1：已授权，2：已过期
     */
    private Integer fwsqzt;

    /**
     * 授权类型：1-月授权(30天) 2-年授权(365天)
     */
    private Integer sqlx;

    /**
     * 服务开始时间， 格式yyyy-MM-dd
     */
    private String fwkssj;

    /**
     * 服务到期时间， 格式yyyy-MM-dd
     */
    private String fwdqsj;
}
