package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电开通发票数据
 */
@Data
public class BlueBillingInvoiceInfoRequestVO {
    /**
     * 发票标识
     */
    private String fpwysbh;

    /**
     * 发票票种
     *
     * @Description 全电专票：01      全电普票：02
     */
    private String fppzDm;

    /**
     * 购买方自然人标识：N-不是
     */
    private String gmfZrrbs;

    /**
     * 销售方自然人标识：N-不是
     */
    private String xsfZrrbs;

    //=====================================销方信息==========================================

    /**
     * 销售方名称
     */
    private String xsfmc;

    /**
     * 销售方地址
     */
    private String xsfdz;

    /**
     * 销售方联系电话
     */
    private String xsflxdh;

    /**
     * 销售方开户行
     */
    private String xsfkhh;

    /**
     * 销售方开户账号
     */
    private String xsfyhzh;

    //=====================================购方信息==========================================

    /**
     * 购买方纳税人识别号
     */
    private String gmfnsrsbh;

    /**
     * 购买方名称
     */
    private String gmfmc;

    /**
     * 购买方地址
     */
    private String gmfdz;

    /**
     * 购买方联系电话
     */
    private String gmflxdh;

    /**
     * 购买方开户行
     */
    private String gmfkhh;

    /**
     * 购买方银行账号
     */
    private String gmfyhzh;

    /**
     * 合计金额
     */
    private BigDecimal hjje;

    /**
     * 合计税额
     */
    private BigDecimal hjse;

    /**
     * 价税合计
     */
    private BigDecimal jshj;

    /**
     * 扣除额（没有填0）
     */
    private BigDecimal kce;

    /**
     * 备注
     */
    private String bz;

    /**
     * 含税标志：1（不含税） 2含税
     */
    private String hsbz;

    /**
     * 明细列表
     */
    private List<InvoiceCommodityRequestVO> mxlb;

    /**
     * 特定业务编码：03-建筑服务发票
     */
    private String tdywbm;

    /**
     * 建筑服务行业信息
     */
    private BlueConstructionProjectInfoVO jzfwhyxx;

    /**
     * 差额征收类型
     */
    private String cezslx;

    /**
     * 差额凭证明细列表
     */
    private List<BalanceDocumentDetailVO> cepzmxlb;
}
