package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 获取已勾选/未勾选数据
 *
 * @author yfx
 * @since 1.0.0 2022-03-29
 */
@Data
public class InputInvoiceVO implements Serializable {

    /**
     * 发票类型：
     */
    private String fplxdm;

    /**
     * 发票代码：
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 全电发票号码
     */
    private String qdfphm;

    /**
     * 开票时间（yyyy-MM-dd HH:mm:ss）
     */
    private String kprq;

    /**
     * 金额（不含税）
     */
    private BigDecimal je;

    /**
     * 税额
     */
    private BigDecimal se;

    /**
     * 有效税额（可抵扣税额）
     */
    private BigDecimal yxse;

    /**
     * 购方税号
     */
    private String gfsbh;

    /**
     * 购方名称
     */
    private String gfmc;

    /**
     * 销方税号
     */
    private String xfsbh;

    /**
     * 消方名称
     */
    private String xfmc;

    /**
     * 发票来源：1（增值税发票管理系统）；2（电子发票服务平台）
     */
    private String fpbbdm;

    /**
     * 勾选状态：0（未勾选）；1（已勾选）
     */
    private String gxztdm;

    /**
     * 勾选时间（yyyy-MM-dd HH:mm:ss）
     */
    private String gxsj;

    /**
     * 发票状态：0（正常）；2（作废）；7（部分红冲）；8（全部红冲）
     * 默认全部
     * 对应:FpztDm
     */
    private String fpztdm;

    /**
     * 风险等级：01（正常）；02（异常凭证）；03（疑点发票）
     */
    private String fxdjdm;

    /**
     * 红字发票锁定标志：N（未锁定）
     */
    private String yhzsdbz;

    /**
     * 不抵扣原因
     */
    private String bdkyy;

}
