package cn.com.servyou.dto.invoice.digitization;


import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wulg
 * @since 20231123
 */
@Data
public class InvoiceAccountStatusVO {

    private String mxuuid;

    private String rzuuid;

    /**
     * 入账状态
     */
    private String rzzt;

    /**
     * 入账时间
     */
    private String rzsj;

    /**
     * 发票状态
     */
    private String fpztdm;

    /**
     * 红字发票锁定标志：N（未锁定）
     */
    private String yhzsdbz;

    /**
     * 风险等级：01（正常）；02（异常凭证）；03（疑点发票）
     */
    private String fxdjdm;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 全电发票号码
     */
    private String qdfphm;

    /**
     * 开票日期（yyyy-MM-dd hh:mm:ss）
     */
    private String kprq;

    /**
     * 销方税号
     */
    private String xfsbh;

    /**
     * 销售方名称
     */
    private String xfmc;

    /**
     * 金额（不含税）
     */
    private BigDecimal je;

    /**
     * 税额
     */
    private BigDecimal se;

    /**
     * 发票类型
     */
    private String fplxdm;

    /**
     * 发票票种：01-数电专票，02-数电普票
     */
    private String fppzdm;

    /**
     * 发票来源：1（增值税发票管理系统）；2（电子发票服务平台）
     */
    private String fpbbdm;
}
