package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wulg
 * @since 20231026
 */
@Data
public class InvoiceCheckDetailVO {

    /**
     * 发票类型：
     * 01（增值税专用发票）
     * 81（全电发票(增值税专用发票)
     */
    private String fplxdm;

    /**
     * 发票状态：0（正常）；2（作废）；7（部分红冲）；8（全部红冲）
     * 默认全部
     * 对应:FpztDm
     */
    private String fpztdm;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 全电发票号码
     */
    private String qdfphm;

    /**
     * 开票日期（yyyy-MM-dd HH:mm:dd）
     */
    private String kprq;

    /**
     * 发票金额
     */
    protected BigDecimal je;

    /**
     * 发票税额
     */
    protected BigDecimal se;

    /**
     * 红字发票锁定标志：N（未锁定）
     */
    private String yhzsdbz;
}
