package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 全电开票商品对象
 *
 * @author rjq
 * @since 20230323
 */
@Data
public class InvoiceCommodityRequestVO {
    /**
     * 序号
     */
    private Integer xh;

    /**
     * 发票行性质代码：0(商品行)；2(被折扣行)；1（折扣行）
     */
    private String fphxzDm;

    /**
     * 商品服务简称
     * 如：水果
     */
    private String spfwjc;

    /**
     * 项目名称
     * 如：苹果
     */
    private String xmmc;

    /**
     * 货物和应税劳务服务名称
     * 如：*水果*苹果
     */
    private String hwhyslwfwmc;

    /**
     * 商品编码
     */
    private String spbm;

    /**
     * 规格型号
     */
    private String ggxh;

    /**
     * 单位
     */
    private String dw;

    /**
     * 商品数量
     */
    private String spsl;

    /**
     * 单价
     */
    private String dj;

    /**
     * 金额
     */
    private BigDecimal je;

    /**
     * 税率：如（0.03）
     */
    private String slv;

    /**
     * 税额
     */
    private BigDecimal se;

    /**
     * 含税金额
     */
    private BigDecimal hsje;

    /**
     * 扣除额：初始值填空
     */
    private String kce;

    /**
     * 含税单价
     */
    private BigDecimal hsdj;

    /**
     * 不含税单价
     */
    private BigDecimal bhsdj;

    /**
     * 不含税金额
     */
    private BigDecimal bhsje;

    /**
     * 享受优惠资产标志：Y和""
     */
    private String xsyhzcbz;

    /**
     * 税收优惠政策类型代码
     */
    private String ssyhzclxDm;
}
