package cn.com.servyou.dto.invoice.digitization;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 订阅记录
 *
 * @author wulg
 * @since 20230525
 */
@Data
public class InvoiceDigitizationSubscriptionRecordVO {

    /**
     * 服务起始时间,yyyyMMdd
     */
    @JsonProperty("fwkssj")
    private String licenseDateBegin;

    /**
     * 服务结束时间,yyyyMMdd
     */
    @JsonProperty("fwjssj")
    private String licenseDateEnd;

    /**
     * 订阅类型:1月度订阅;2年度订阅
     */
    @JsonProperty("dylx")
    private Integer authType;

    /**
     * 订阅方式:0手动订阅，默认0-否;1自动订阅
     */
    @JsonProperty("dyfs")
    private Integer autoTab;

    /**
     * 操作时间
     * 格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("czsj")
    private String createTime;
}
