package cn.com.servyou.dto.invoice.digitization;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;


/**
 * 订阅数据&订阅记录
 *
 * @author wulg
 * @since 20230525
 */
@Data
public class InvoiceDigitizationSubscriptionVO extends BaseStateResultVO {

    /**
     * 简称
     */
    @JsonProperty("qymc")
    private String customerName;

    /**
     * 税号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 授权状态:0已过期;1已授权;2未订阅
     */
    @JsonProperty("dyzt")
    private Integer state;

    /**
     * 订阅类型:1-月度订阅（30天）;2-年度订阅（365天）
     */
    @JsonProperty("dylx")
    private Integer authType;

    /**
     * 自动续订状态 0已关闭/1已开启
     */
    @JsonProperty("zdxdzt")
    private Boolean autoRenewFlag;

    /**
     * 订阅记录列表
     */
    @JsonProperty("dyjllb")
    private List<InvoiceDigitizationSubscriptionRecordVO> invoiceDigitizationSubscriptionRecordList;
}
