package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 全电发票--发票信息对象
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class InvoiceInfoResultVO extends BaseStateResultVO {
    /**
     * 发票标识
     */
    private String fpwysbh;

    /**
     * 发票票种
     *
     * @Description 全电专票：01 全电普票：02
     */
    private String fppzDm;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 开票日期
     *
     * @Description yyyy-MM-dd HH:mm:ss
     */
    private String kprq;

    /**
     * 合计金额
     */
    private BigDecimal hjje;

    /**
     * 合计税额
     */
    private BigDecimal hjse;

    /**
     * 价税合计（中文）
     */
    private String jshjchn;

    /**
     * 价税合计
     */
    private BigDecimal jshj;

    /**
     * 扣除额（没有填0）
     */
    private BigDecimal kce;

    //=====================================销方信息==========================================

    /**
     * 销货方登记序号
     */
    private String xsfDjxh;

    /**
     * 销货方名称
     */
    private String xsfmc;

    /**
     * 销货方纳税人识别号
     */
    private String xsfnsrsbh;

    /**
     * 销货方地址
     */
    private String xsfdz;

    /**
     * 销货方联系电话
     */
    private String xsflxdh;

    /**
     * 销货方开户行
     */
    private String xsfkhh;

    /**
     * 销货方开户账号
     */
    private String xsfyhzh;

    //=====================================购方信息==========================================
    /**
     * 购买方名称登记序号
     */
    private String gmfdjxh;

    /**
     * 购买方纳税人识别号
     */
    private String gmfnsrsbh;

    /**
     * 购买方名称
     */
    private String gmfmc;

    /**
     * 购买方地址
     */
    private String gmfdz;

    /**
     * 购买方电话
     */
    private String gmflxdh;

    /**
     * 购买方银行
     */
    private String gmfkhh;

    /**
     * 购买方银行账号
     */
    private String gmfyhzh;

    /**
     * 开票纳税人识别号
     */
    private String kpfnsrsbh;

    /**
     * 二维码
     */
    private String ewm;

    /**
     * 开票人
     */
    private String kpr;

    /**
     * 复核人
     */
    private String fhr;

    /**
     * 蓝字发票标志
     */
    private String sflzfpbz;

    /**
     * pdf文件地址
     */
    private String wjdz;

    /**
     * 备注
     */
    private String bz;

    /**
     * 明细列表
     */
    private List<InvoiceCommodityResultVO> mxlb;


    /**
     * 特定业务编码：03-建筑服务发票
     */
    private String tdywbm;

    /**
     * 建筑服务行业信息
     */
    private BlueConstructionProjectInfoVO jzfwhyxx;

    /**
     * 差额征收类型
     */
    private String cezslx;
}
