package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 票面信息
 *
 * @author rjq
 * @since 20230323
 */
@Data
public class InvoiceTabInfoResultVO {
    /**
     * 发票票种
     *
     * @Description 全电专票：01 全电普票：02
     */
    private String fppzDm;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 开票日期
     *
     * @Description yyyy-MM-dd HH:mm:ss
     */
    private String kprq;


    /**
     * 购买方自然人标识：N-不是
     */
    private String gmfZrrbs;

    /**
     * 合计金额
     */
    private BigDecimal hjje;

    /**
     * 合计税额
     */
    private BigDecimal hjse;

    /**
     * 价税合计（中文）
     */
    private String jshjchn;

    /**
     * 价税合计
     */
    private BigDecimal jshj;

    //=====================================销方信息==========================================


    /**
     * 销货方名称
     */
    private String xsfmc;

    /**
     * 销货方纳税人识别号
     */
    private String xsfnsrsbh;


    //=====================================购方信息==========================================

    /**
     * 购买方纳税人识别号
     */
    private String gmfnsrsbh;

    /**
     * 购买方名称
     */
    private String gmfmc;


    /**
     * 蓝字发票标志
     */
    private String sflzfpbz;


    /**
     * 购进标签代码 1：开具的发票   2：取得发票，用于标识销项票和进项票  本期默认1
     */
    private String gjbqdm;

    /**
     * 发票类型代码
     */
    private String fplxdm;

    /**
     * 发票状态代码
     */
    private String fpztDm;

    /**
     * 开具红字发票对应的蓝字发票发票号码
     */
    private String kjhzfpdydlzfphm;

    private String kpr;
}
