package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发票不抵扣勾选详细信息
 *
 * @author lyj
 * @since 2022/6/17 10:51
 */
@Data
public class NotDeductionCheckInvoiceDetailVO implements Serializable {

    /**
     * 红字发票锁定标志：N（未锁定）
     */
    private String yhzsdbz;

    /**
     * 发票来源：1（增值税发票管理系统）；2（电子发票服务平台）
     */
    private String fpbbdm;

    /**
     * 发票代码
     */
    private String fpdm;

    /**
     * 发票号码
     */
    private String fphm;

    /**
     * 全电发票号码
     */
    private String qdfphm;

    /**
     * 开票日期（yyyy-MM-dd）
     */
    private String kprq;

    /**
     * 发票金额
     */
    private BigDecimal je;

    /**
     * 发票税额
     */
    private BigDecimal se;

    /**
     * 发票类型：
     * 01（增值税专用发票）
     * 81（全电发票(增值税专用发票)
     */
    private String fplxdm;

    /**
     * 发票状态：0（正常）；1（失控）；2（作废）；3（已红冲）；7（已部分红冲）；8（已全额红冲）；
     */
    private String fpztdm;

    /**
     * 有效税额（可抵扣税额）
     */
    private BigDecimal yxse;

    /**
     * 不抵扣原因代码
     * <p>
     * 用于非应税项目：1
     * 用于免税项目：2
     * 用于集体福利或者个人消费：3
     * 非正常损失的：4
     * 其他：5
     */
    private String bdkyy;

    /**
     * 不抵扣原因(文字)
     */
    private String bdkyywz;
}
