package cn.com.servyou.dto.invoice.digitization;

import cn.com.servyou.dto.invoice.InvoiceBaseRequestVO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wulg
 * @since 20231123
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryAccountStatusRequestVO extends InvoiceBaseRequestVO {

    /**
     * 页码
     */
    private Integer pageNumber;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 全电发票号码
     * 对应 Fphm
     */
    private String qdfphm;

    /**
     * 发票代码
     * 对应 ZzfpDm
     */
    private String fpdm;

    /**
     * 发票号码
     * 对应 Zzfphm
     */
    private String fphm;

    /**
     * 销方识别号
     * 对应 Xsfnsrsbh
     */
    private String xfsbh;

    /**
     * 销方名称
     * 对应 Xsfmc
     */
    private String xfsmc;

    /**
     * 开票日期起
     * 对应 kprqq
     */
    private String kprqq;

    /**
     * 开票日期止
     * 对应 kprqz
     */
    private String kprqz;

    /**
     * 入账状态
     * 对应 Rzyt_dm
     * {
     * "Rzyt_dm": "01",
     * "Rzytmc": "未入账"
     * },
     * {
     * "Rzyt_dm": "02",
     * "Rzytmc": "已入账（企业所得税税前扣除）"
     * },
     * {
     * "Rzyt_dm": "03",
     * "Rzytmc": "已入账（企业所得税不扣除）"
     * },
     * {
     * "Rzyt_dm": "06",
     * "Rzytmc": "入账撤销"
     * }
     */
    private String rzzt;
}
