package cn.com.servyou.dto.invoice.digitization;

import cn.com.servyou.dto.invoice.InvoiceBaseRequestVO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 全量发票查询入参
 *
 * @author rjq
 * @since 20230420
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryFullInvoiceRequestVO extends InvoiceBaseRequestVO {
    /**
     * 开票日期起
     *
     * @Description 格式：yyyy-MM-dd，可查询近36个月的发票数据
     */
    private String kprqq;

    /**
     * 开票日期止
     *
     * @Description 格式：yyyy-MM-dd，起止日期跨度不可超过12个月
     */
    private String kprqz;

    /**
     * 数电票号码
     *
     * @Description 20位数字
     */
    private String fphm;

    private Integer pageNo;

    private Integer pageSize;
}
