package cn.com.servyou.dto.invoice.digitization;

import cn.com.servyou.dto.invoice.InvoiceBaseRequestVO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author wulg
 * @since 20231026
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryInputCheckOrUnCheckRequestVO extends InvoiceBaseRequestVO {

    /**
     * 页码
     */
    private Integer pageNumber;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 发票来源： 1（增值税发票管理系统）；2（电子发票服务平台）；-1（全部）
     * 默认全部
     */
    private String fpbbdm;

    /**
     * 勾选状态：0（未勾选）；1（已勾选）
     * 对应：GxztDm
     */
    private String gxztdm;

    /**
     * 发票状态：0（正常）；2（作废）；7（部分红冲）；8（全部红冲）
     * 默认全部
     */
    private String fpztdm;

    /**
     * 风险等级：01（正常）；02（异常凭证）；03（疑点发票）
     * 默认全部
     */
    private String fxdjdm;

    /**
     * 发票类型；
     * 默认全部
     */
    private List<String> fplxdm;

    /**
     * 开票日期起（yyyy-MM-dd）
     * 对应：KprqQ
     */
    private String kprqq;

    /**
     * 开票日期止（yyyy-MM-dd）
     * 对应：KprqZ
     */
    private String kprqz;
}
