package cn.com.servyou.dto.invoice.digitization;

import cn.com.servyou.dto.invoice.InvoiceBaseRequestVO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wulg
 * @since 20231026
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryNotDeductionInvoiceRequestVO extends InvoiceBaseRequestVO {

    /**
     * 页码
     */
    private Integer pageNumber;

    /**
     * 分页大小
     */
    private Integer pageSize;

    /**
     * 发票来源： 1（增值税发票管理系统）；2（电子发票服务平台）；-1（全部）
     * 默认全部
     */
    private String fpbbdm;

    /**
     * 勾选状态：0（未勾选）；1（已勾选）
     * 对应：GxztDm
     */
    private String gxztdm;

    /**
     * 开票日期起（yyyy-MM-dd）
     * 对应：KprqQ
     */
    private String kprqq;

    /**
     * 开票日期止（yyyy-MM-dd）
     * 对应：KprqZ
     */
    private String kprqz;

    /**
     * 税款所属期
     * 不抵扣勾选记录查询需要传入
     */
    private String skssq;
}
