package cn.com.servyou.dto.invoice.digitization;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author sunjl
 * @since 20230420
 */
@Data
public class QueryRedInvoiceVoucherDetailResultVO {

    /**
     * 红字发票确认单编号
     */
    private String hzfpqrdbh;

    /**
     * 销售方纳税人识别号
     */
    private String xsfnsrsbh;

    /**
     * 销售方名称
     */
    private String xsfmc;

    /**
     * 购买方纳税人识别号
     */
    private String gmfnsrsbh;

    /**
     * 购买方名称
     */
    private String gmfmc;

    /**
     * 蓝字发票号码
     */
    private String lzfphm;

    /**
     * 蓝字开票日期
     */
    private String lzkprq;

    /**
     * 蓝字合计金额
     */
    private BigDecimal lzhjje;

    /**
     * 蓝字合计税额
     */
    private BigDecimal lzhjse;

    /**
     * 蓝字发票票种代码
     */
    private String lzfppzdm;

    /**
     * 增值税用途状态
     *
     * @Description 03：未勾选
     */
    private String zzsytzt;

    /**
     * 消费税用途状态
     *
     * @Description 00：未勾选
     */
    private String xfsytzt;

    /**
     * 入账状态
     *
     * @Description 00：未入账
     */
    private String rzzt;

    /**
     * 红字冲销金额
     */
    private BigDecimal hzcxje;

    /**
     * 红字冲销税额
     */
    private BigDecimal hzcxse;

    /**
     * 红字冲销原因
     *
     * @Description 01：开票有误
     * 02：销货退回
     * 03：服务中止
     * 04：销售折让
     */
    private String hzcxyy;

    /**
     * 红字确认状态
     *
     * @Description 01：无需确认
     * 08：作废（发起方已撤销）
     */
    private String hzqrzt;

    /**
     * 确认日期
     */
    private String qrrq;

    /**
     * 红字发票号码
     */
    private String hzfphm;

    /**
     * 红字开票日期
     */
    private String hzkprq;

    /**
     * 红字确认单录入日期
     */
    private String hzqrdlrrq;

    /**
     * 红字确认单明细列表
     */
    private List<QueryRedInvoiceVoucherDetailItemVO> hzqrdmxlb;

}
